/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CEdit.h,v 1.2 1999/09/17 04:20:47 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CEdit_h	// [
#define Included_CEdit_h

#include "pgpClassesConfig.h"
#include "CWindow.h"

_PGP_BEGIN

// Class CEdit

class CEdit : public CWindow
{
private:
	enum {MaxLineLength = 256};

public:
	CEdit() { }
	CEdit(HWND hWnd) : CWindow(hWnd) { }
	~CEdit() { }

	PGPBoolean	GetLine(PGPUInt32 lineNum, CString& line) const;

	PGPUInt32	GetLineCount() const
	{
		return SendMessage(EM_GETLINECOUNT, 0, 0);
	}

	void		LimitText(PGPUInt32 limit) const
	{
		SendMessage(EM_LIMITTEXT, limit, 0);
	}
	
	void		SetSel(PGPInt32 start, PGPInt32 end) const
	{
		SendMessage(EM_SETSEL, start, end);
	}
};

_PGP_END

#endif	// ] Included_CEdit_h
